<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// ambil pinjaman disetujui
$sql = "SELECT p.*, a.nama 
        FROM pinjaman p
        JOIN anggota a ON p.anggota_id = a.id
        WHERE p.status = 'disetujui'
        ORDER BY p.tanggal DESC";
$result = $db->query($sql);
?>

<h2>Angsuran Pinjaman</h2>

<table class="table">
    <thead>
        <tr>
            <th>No</th>
            <th>Anggota</th>
            <th>Jumlah</th>
            <th>Sisa</th>
            <th>Bayar Angsuran</th>
        </tr>
    </thead>
    <tbody>
        <?php $no=1; while($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= $row['nama']; ?></td>
            <td>Rp <?= number_format($row['jumlah'],0,',','.'); ?></td>
            <td>Rp <?= number_format($row['sisa'],0,',','.'); ?></td>
            <td>
                <form action="../../process/pinjaman_process.php" method="POST">
                    <input type="hidden" name="aksi" value="angsuran">
                    <input type="hidden" name="id" value="<?= $row['id']; ?>">
                    <input type="number" name="bayar" required placeholder="Nominal" min="1000">
                    <button class="btn btn-success">Bayar</button>
                </form>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<?php require_once '../../templates/footer.php'; ?>
